/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.model.UnlimitedHours;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.IntValueProperties;
import DE.siemens.ad.udf.UDFParameterItem;
import java.io.IOException;

public class Reference
extends TimeUnit {
    static final long serialVersionUID = 3103795312873884716L;
    private int referenceSerializedDataVersion = 1;
    protected TimeUnit fTimeUnit;
    protected ParameterItem fReference;
    private int fVMDataLength;
    private int fAddress = -1;

    public String getDefaultUnitString() {
        return "Reference";
    }

    public IntValueProperties getHigh() {
        TimeUnit timeUnit = this.getTimeUnit();
        timeUnit.setTime(this.getReferencedValue());
        return timeUnit.getHigh();
    }

    public int getHighValue() {
        TimeUnit timeUnit = this.getTimeUnit();
        timeUnit.setTime(this.getReferencedValue());
        return timeUnit.getHighValue();
    }

    public int[] getLogoTime() {
        int aWord = 0;
        aWord = this.getTimeUnit() instanceof UnlimitedHours ? 0 : (aWord |= (this.getTimeUnit().getLogoTime()[0] & 0xC0) << 8);
        ParameterItem paraItem = this.getReference();
        if (paraItem != null) {
            aWord = paraItem instanceof UDFParameterItem ? (aWord += ((UDFParameterItem)paraItem).getRootSourceParameterItem().getParameter().getBlock().getNumber()) : (aWord += this.getReference().getParameter().getBlock().getNumber());
        }
        return new int[]{aWord >> 8 & 0xFF, aWord & 0xFF};
    }

    public IntValueProperties getLow() {
        TimeUnit timeUnit = this.getTimeUnit();
        timeUnit.setTime(this.getReferencedValue());
        return timeUnit.getLow();
    }

    public int getLowValue() {
        TimeUnit timeUnit = this.getTimeUnit();
        timeUnit.setTime(this.getReferencedValue());
        return timeUnit.getLowValue();
    }

    public int getTimeValue() {
        TimeUnit timeUnit = this.getTimeUnit();
        timeUnit.setTime(this.getReferencedValue());
        return timeUnit.getTimeValue();
    }

    public long getMilliseconds() {
        TimeUnit timeUnit = this.getTimeUnit();
        timeUnit.setTime(this.getReferencedValue());
        return timeUnit.getMilliseconds();
    }

    public int getReferencedValue() {
        int ret = 0;
        if (this.isVMReference()) {
            ret = this.getVMValue();
        } else {
            Object value = this.getReference().getValue();
            if (value instanceof IntValueProperties) {
                ret = ((IntValueProperties)value).getCurrentValue();
            } else if (value instanceof TimeUnit) {
                ret = ((TimeUnit)value).getReferencedValue();
            } else if (value instanceof Integer) {
                ret = (Integer)value;
            } else if (value instanceof Double) {
                ret = ((Double)value).intValue();
            } else if (value instanceof Long) {
                ret = ((Long)value).intValue();
            }
            if (this.getTimeUnit() instanceof UnlimitedHours) {
                ret *= 60;
            }
        }
        return ret;
    }

    public String getUnitAbbreviation() {
        return this.getTimeUnit().getUnitAbbreviation();
    }

    public String getUnitKey() {
        return this.getTimeUnit().getUnitKey();
    }

    public void setTime(int high, int low) {
        this.getTimeUnit().setTime(high, low);
    }

    public TimeUnit setTime(int value) {
        this.getTimeUnit().setTime(value);
        return this;
    }

    public ParameterItem getReference() {
        return this.fReference;
    }

    public TimeUnit getTimeUnit() {
        return this.fTimeUnit;
    }

    public void setReference(ParameterItem reference) {
        this.fReference = reference;
        if (reference != null) {
            this.setVMDataLength(0);
            this.setAddress(0);
        }
    }

    public void setTimeUnit(TimeUnit value) {
        this.fTimeUnit = value;
    }

    public String getParameterText() {
        StringBuffer result = new StringBuffer();
        try {
            if (this.isVMReference()) {
                result.append(Global.getVMAbbreviation(this.getVMDataLength())).append(this.fAddress);
            } else {
                Block block = this.getReference().getParameter().getBlock();
                result.append(block.getNumberPrefix()).append(Integer.toString(block.getNumber()));
            }
            if (this.getTimeUnit() instanceof UnlimitedHours) {
                result.append("h");
            } else {
                result.append(this.getLowValueUnitAbbreviation());
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        return result.toString();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        if (!this.isReference()) {
            result.append("noReference/");
        } else if (this.getReference() != null) {
            BlockParameter param = this.getReference().getParameter();
            if (param != null) {
                result.append(param.getBlock().getNumberString());
                result.append("/");
            } else {
                result.append("noParameter/");
            }
            result.append(super.getParameterText());
        } else {
            result.append(Global.getVMAbbreviation(this.getVMDataLength())).append(this.fAddress);
            result.append("/");
        }
        return result.toString();
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeStorable(this.fTimeUnit);
        dw.writeStorable(this.fReference);
        dw.writeInt(this.fVMDataLength);
        dw.writeInt(this.fAddress);
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fTimeUnit = (TimeUnit)dr.readStorable();
        this.fReference = (ParameterItem)dr.readStorable();
        this.fVMDataLength = dr.readInt();
        this.fAddress = dr.readInt();
    }

    public String getLowValueUnitKey() {
        return this.getTimeUnit().getLowValueUnitKey();
    }

    public String getLowValueUnitAbbreviation() {
        return this.getTimeUnit().getLowValueUnitAbbreviation();
    }

    public int getAddress() {
        return this.fAddress;
    }

    public void setAddress(int address) {
        this.fAddress = address;
    }

    public boolean isVMReference() {
        return this.fVMDataLength > 0;
    }

    public boolean isReference() {
        return this.isVMReference() || this.getReference() != null;
    }

    public int getVMDataLength() {
        return this.fVMDataLength;
    }

    public void setVMDataLength(int dataType) {
        this.fVMDataLength = dataType;
        if (this.fVMDataLength > 0) {
            this.fReference = null;
        }
    }

    public int getVMValue() {
        if (this.fInterpreter == null) {
            return 0;
        }
        return this.fInterpreter.readVM(this.fVMDataLength, this.fAddress);
    }
}

